<?php
date_default_timezone_set('Asia/Tokyo');

/* 1. パラメータ取得 & サニタイズ */
$id    = isset($_GET['id'])    ? preg_replace('/[^A-Za-z0-9_-]/', '', $_GET['id']) : 'unknown';
$ts1   = isset($_GET['ts1'])   ? preg_replace('/[^0-9_]/',       '', $_GET['ts1']) : '';
$ts2   = isset($_GET['ts2'])   ? preg_replace('/[^0-9:]/',       '', $_GET['ts2']) : '';
$hr    = isset($_GET['hr'])    ? floatval($_GET['hr'])                             : 0.0; // HR を先に
$ibi    = isset($_GET['ibi'])    ? intval($_GET['ibi'])                               : 0;   // IBI を後に
$rmssd = isset($_GET['rmssd']) ? floatval($_GET['rmssd'])                          : 0.0;

/* ★ 追加：生波形（RAW mV）早期追記モード
   使い方：?id=ECG01&mv=0.00123[&ts_ms=1695540001234]
   備考：同日CSVの末尾に "RAW,<ts_ms>,<mv>" を追記．既存仕様は不変更．
*/
if (isset($_GET['mv'])) {
    $mv = floatval($_GET['mv']);

    $saveDir = '/home/kodamalab/www/KAMIYA/K3/Result';
    if (!is_dir($saveDir) && !mkdir($saveDir, 0755, true)) {
        http_response_code(500); exit('cannot create dir');
    }
    $date  = date('Ymd');
    $fname = "{$saveDir}/{$id}_{$date}.csv";

    // ts_ms（ミリ秒）優先，なければ ts1/ts2 から復元，さらに無ければ現在時刻
    $ts_ms = '';
    if (isset($_GET['ts_ms'])) {
        $ts_ms = preg_replace('/[^0-9]/','', $_GET['ts_ms']);
    }
    if ($ts_ms === '' && $ts1 !== '') {
        $ts1digits = preg_replace('/[^0-9]/','', $ts1);
        if (strlen($ts1digits) >= 14) {
            $datePart = substr($ts1digits, 0, 8);
            $timePart = substr($ts1digits, 8, 6);
            $msPart   = (strlen($ts1digits) > 14) ? substr($ts1digits, 14, 3) : '000';
            $dt = DateTime::createFromFormat('YmdHis', $datePart.$timePart);
            if ($dt) $ts_ms = (string)($dt->getTimestamp()*1000 + intval($msPart));
        }
    }
    if ($ts_ms === '' && $ts2 !== '') {
        $ts2digits = preg_replace('/[^0-9]/','', $ts2);
        if (strlen($ts2digits) >= 6) {
            $dt = DateTime::createFromFormat('YmdHis', date('Ymd').$ts2digits);
            if ($dt) $ts_ms = (string)($dt->getTimestamp()*1000);
        }
    }
    if ($ts_ms === '') { $ts_ms = (string)((int)round(microtime(true)*1000)); }

    $isNew = !file_exists($fname);
    $fp = fopen($fname, 'a');
    if (!$fp || !flock($fp, LOCK_EX)) {
        http_response_code(500); exit('file open/lock error');
    }
    if ($isNew) {
        // 新規作成時のみヘッダを用意（既存仕様を尊重）
        fputcsv($fp, ['ts1','ts2','IBI','HR','RMSSD']);
    }
    fwrite($fp, "RAW,{$ts_ms}," . number_format($mv, 6, '.', '') . "\n");
    flock($fp, LOCK_UN);
    fclose($fp);
    http_response_code(200);
    echo 'OK';
    exit; // 既存処理には進まない
}

if ($ts1 === '') { http_response_code(400); exit('timestamp missing'); }

/* 2. ファイルパス決定 */
$saveDir = '/home/kodamalab/www/KAMIYA/K3/Result';
$date    = date('Ymd');
$fname   = "{$saveDir}/{$id}_{$date}.csv";

/* 3. ディレクトリ確保 */
if (!is_dir($saveDir) && !mkdir($saveDir, 0755, true)) {
    http_response_code(500); exit('cannot create dir');
}

/* 4. 既存ファイル読み込み */
$records = [];                // ['ts1' => [ts1, ts2, HR, IBI, RMSSD]]
if (file_exists($fname)) {
    if (($fp = fopen($fname, 'r')) !== false) {
        while (($row = fgetcsv($fp)) !== false) {
            if ($row[0] === 'ts1') continue;  // ヘッダー除外
            $records[$row[0]] = $row;
        }
        fclose($fp);
    }
}

/* ★ 追加：既存CSV中のRAW行を退避（上書き保存時に消えないよう保持） */
$__rawLinesKeep = [];
if (file_exists($fname)) {
    $lines = @file($fname, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if ($lines !== false) {
        foreach ($lines as $ln) {
            if (strncmp($ln, 'RAW,', 4) === 0) $__rawLinesKeep[] = $ln;
        }
    }
}
/* ★ 追加：キーが ts1（数値＋アンダースコア）の行のみ残す（RAW等は除外） */
foreach ($records as $k => $row) {
    if (!preg_match('/^[0-9_]+$/', (string)$k)) { unset($records[$k]); }
}

/* 5. 上書き or 追加 */
$records[$ts1] = [$ts1, $ts2, $ibi, $hr, $rmssd];

/* 6. ts1 を文字列として昇順ソート（時系列整合）*/
ksort($records, SORT_STRING);

/* 7. 上書き保存（排他ロック）*/
$fp = fopen($fname, 'w');
if (!$fp || !flock($fp, LOCK_EX)) {
    http_response_code(500); exit('file open/lock error');
}
fputcsv($fp, ['ts1', 'ts2', 'IBI', 'HR', 'RMSSD']);   // ヘッダーも HR → RR

foreach ($records as $row) {
    fputcsv($fp, $row);
}

/* ★ 追加：退避RAW行を末尾に再付与 */
if (!empty($__rawLinesKeep)) {
    fwrite($fp, "\n");
    foreach ($__rawLinesKeep as $ln) { fwrite($fp, $ln . "\n"); }
}

flock($fp, LOCK_UN);
fclose($fp);

http_response_code(200);
echo 'OK';
