<?php
// SoundControl.php — 音声フィードバック ON/OFF 管理

date_default_timezone_set('Asia/Tokyo');
$saveDir = '/home/kodamalab/www/KAMIYA/K3/SoundControl';
if (!file_exists($saveDir)) mkdir($saveDir,0755,true);

// デバイスID を取得・サニタイズ
$id = isset($_GET['id'])
    ? preg_replace('/[^A-Za-z0-9_-]/','',$_GET['id'])
    : 'unknown';
$stateFile = "{$saveDir}/{$id}_sound.txt";

// ———— コマンドによる切り替え ————
if (isset($_GET['cmd'])) {
    $cmd = $_GET['cmd']==='on' ? '1' : '0';
    file_put_contents($stateFile, $cmd, LOCK_EX);
    http_response_code(200);
    echo "OK";
    exit;
}

// ———— 状態問い合わせ ————
if (isset($_GET['getState'])) {
    if (file_exists($stateFile)) {
        echo trim(file_get_contents($stateFile));
    } else {
        // デフォルト ON
        echo "1";
    }
    exit;
}

// 不正リクエスト
http_response_code(400);
echo "Bad Request";
