import pandas as pd

# Excelファイル読み込み（縦に617個）
df = pd.read_excel("input.xlsx", header=None)

# A列 0〜616行目のデータを Series として取得
col = df.iloc[:940, 0]

# 累積加算処理（A+B → B', B'+C → C'...）
result = []
temp = col[0] + col[1]
result.append(temp)

for i in range(2, len(col)):
    temp += col[i]
    result.append(temp)

# 結果を横向きに変換（1行にする）
result_df = pd.DataFrame([result])

# 保存（output.xlsx に保存）
result_df.to_excel("output.xlsx", header=False, index=False)
