#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BNO055.h>
#include <utility/imumaths.h>

Adafruit_BNO055 bno = Adafruit_BNO055(-1, 0x28, &Wire);

void setup() {
  Serial.begin(115200);
  while (!Serial) {}

  Serial.println("=== BNO055 Calibration Mode ===");

  if (!bno.begin()) {
    Serial.println("ERROR: BNO055 not detected!");
    while (1);
  }

  delay(1000);
  bno.setMode(Adafruit_BNO055::OPERATION_MODE_NDOF);
  delay(20);
  bno.setExtCrystalUse(true);  // 外部クリスタルを使用
  Serial.println("Move the sensor to calibrate...");
  Serial.println("Target: Sys=3, Gyro=3, Accel=3, Mag=3");
}

void loop() {
  uint8_t sys, gyro, accel, mag;
  bno.getCalibration(&sys, &gyro, &accel, &mag);

  Serial.print("CALIB: Sys=");
  Serial.print(sys);
  Serial.print(" Gyro=");
  Serial.print(gyro);
  Serial.print(" Accel=");
  Serial.print(accel);
  Serial.print(" Mag=");
  Serial.println(mag);

  // 全部そろったら通知
  if (sys == 3 && gyro == 3 && accel == 3 && mag == 3) {
    Serial.println("=== CALIBRATION COMPLETE! ===");
  }

  delay(200);
}
