#include <Adafruit_TinyUSB.h>  // XIAO nRF52840系でSerialを使うため

// サンプリング間隔（マイクロ秒）
// 1000us = 1kHzサンプリング
const uint32_t SAMPLE_INTERVAL_US = 2000;
const uint32_t threshold = 1900;

uint32_t lastMicros = 0;

void setup() {
  // LED（お好みで）
  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, HIGH);  // XIAOはHIGHで消灯のことが多い

  // USBシリアル開始
  Serial.begin(115200);
  // 開発中はPC接続を待ってもよい
  while (!Serial) {
    delay(10);
  }

  // ADC分解能を12bitに（0〜4095）
  analogReadResolution(12);
}

void loop() {
  uint32_t now = micros();

  // 一定間隔ごとにサンプリング
  if (now - lastMicros >= SAMPLE_INTERVAL_US) {
    lastMicros += SAMPLE_INTERVAL_US;  // ドリフトを抑える書き方

    // ADCチャネル0（A0ピン）の読み取り
    int value = analogRead(A0);

    // タイムスタンプ[us], ADC値 をCSV形式で送信
    //Serial.print(now);     // マイクロ秒タイムスタンプ
    //Serial.print(",");
    Serial.print(3000);
    Serial.print(",");
    Serial.print(1000);
    Serial.print(",");
    Serial.print(threshold);
    Serial.print(",");
    Serial.println(value); // 0〜4095（12bit）

    if(value>threshold){digitalWrite(LED_BUILTIN, LOW); }
    else{digitalWrite(LED_BUILTIN, HIGH); }

  }
}
