#include <Wire.h>              // I2C通信ライブラリ
#include <Adafruit_ADS1X15.h>  // ADS1015ライブラリ
Adafruit_ADS1015 ads;          // ADS1015クラスのインスタンス化

void setup(void)
{
  Serial.begin(115200);  // シリアル通信開始
  // ADS1015 gain 2/3  input range +/- 6.144V
  ads.begin();           // ADS1015通信開始
}

void loop(void)
{
  int16_t results;  // AD変換結果
  results = ads.readADC_Differential_0_1();  // 差動入力

  float multiplier = 3.0F;  // デフォルトゲイン(2/3倍)における係数
  // 得られたデジタル値をmVに換算しシリアルモニタに表示
  Serial.print(results * multiplier);
  Serial.print(",4000,1000");
  Serial.println();  // シリアルモニタ改行
  delay(0);
}
