//VDD-3V3
//GND-GND
//SDI-IO4
//SCK-IO5
//SDO-GND
#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>

static const uint8_t SDA_PIN = 4; // GPIO4
static const uint8_t SCL_PIN = 5; // GPIO5

Adafruit_BME280 bme; // I2C

void setup() {
  Serial.begin(115200);
  delay(200);

  // I2C開始（ESP8266はピン指定が可能）
  Wire.begin(SDA_PIN, SCL_PIN);
  Wire.setClock(100000); // 100kHz（長い配線なら安定寄り）

  // 0x76 が多い（SDO=GND）。ダメなら 0x77 を試す
  bool ok = bme.begin(0x76);
  if (!ok) ok = bme.begin(0x77);

  if (!ok) {
    Serial.println("BME280 not found. Check wiring / address (0x76 or 0x77).");
    while (true) { delay(1000); }
  }

  // サンプリング設定（用途に応じて調整可）
  bme.setSampling(
    Adafruit_BME280::MODE_NORMAL,
    Adafruit_BME280::SAMPLING_X2,   // Temp
    Adafruit_BME280::SAMPLING_X16,  // Pressure
    Adafruit_BME280::SAMPLING_X1,   // Humidity
    Adafruit_BME280::FILTER_X16,
    Adafruit_BME280::STANDBY_MS_500
  );

  Serial.println("BME280 OK");
}

void loop() {
  float t = bme.readTemperature();          // °C
  float h = bme.readHumidity();             // %
  float p = bme.readPressure() / 100.0F;    // hPa
  float a = bme.readAltitude(1013.25);      // m（海面気圧は適宜変更）

  Serial.print("T=");
  Serial.print(t, 2);
  Serial.print(" C, H=");
  Serial.print(h, 2);
  Serial.print(" %, P=");
  Serial.print(p, 2);
  Serial.print(" hPa, Alt=");
  Serial.print(a, 2);
  Serial.println(" m");

  delay(2000);
}
